//+------------------------------------------------------------------+
//|                                   Trend Indicators Redefined.mq5 |
//|                                          Copyright 2023, Omegafx |
//|                                           https://www.omegafx.co |
//+------------------------------------------------------------------+
#property copyright "Copyright 2023, Omegafx"
#property link      "https://www.mql5.com/en/users/omegajoctan/seller"
#property version   "1.00"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_plots 1

#property indicator_color1 clrDodgerBlue
#property indicator_type1 DRAW_LINE
#property indicator_style1 STYLE_SOLID

#include <ta-lib.mqh>

input int period_ = 20; //SMA period

double buffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   
   SetIndexBuffer(0, buffer, INDICATOR_DATA);
   PlotIndexSetDouble(0, PLOT_EMPTY_VALUE, 0);   
   
   PlotIndexSetString(0,PLOT_LABEL,"SMA("+string(period_)+")");
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,period_+1);
   
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
//---

   if (prev_calculated==0) //Initial indicator calculation, For Plotting the entire past 
     {        
       vector buffer_vector = CTrendIndicators::SMA(close, period_);
       
       VectorToArray(buffer_vector, buffer);
     }
    else //For plotting the current value
     {
       for (int i=prev_calculated-1; i<rates_total; i++) //Loop from the prev_calculated bars -1 to the total bars present 
        {
           double temp_close[]; //For storing temporary close values
           int size = period_*2; //We are going to copy an equivalent of period x 2 to leave a room for NaN values
           
           if (ArrayCopy(temp_close, close, 0, i - size, size) < 0)
            { 
               printf("Failed to copy closing price values to a temporary array, err = %d",GetLastError());
               continue;
            }
           
           vector indicator_values = CTrendIndicators::SMA(temp_close, period_); 
           ulong last_index = indicator_values.Size() - 1; //The last value in the vector is the recent calculated indicator value
           
           buffer[i] = indicator_values[last_index]; //Assing the last indicator value to the last value in the buffer
        }
     }
   
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+------------------------------------------------------------------+
//|      A crude way to convert a vector into Array                  |
//+------------------------------------------------------------------+
template <typename T>
void VectorToArray(const vector<T> &v, T &arr[])
 {
   ArrayResize(arr, (uint)v.Size());
   
   for (uint i=0; i<(uint)v.Size(); i++)
       arr[i] = v[i];
 }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+

